/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.particle.base;

import com.eeeab.eeeabsmobs.client.render.EERenderType;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ParticleOrb
extends TextureSheetParticle {
    private final double duration;

    public ParticleOrb(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, double scale, int duration) {
        super(world, x, y, z);
        this.f_107663_ = (float)scale * 0.1f;
        this.f_107225_ = duration;
        this.f_107215_ = vx;
        this.f_107216_ = vy;
        this.f_107217_ = vz;
        this.duration = duration;
    }

    public ParticleRenderType m_7556_() {
        return EERenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    public int m_6355_(float delta) {
        return 0xF0 | super.m_6355_(delta) & 0xFF0000;
    }

    public void m_5989_() {
        this.f_107230_ = 0.1f;
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        super.m_5989_();
        if (this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        }
        ++this.f_107224_;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        this.f_107230_ = Math.max(1.0f - ((float)this.f_107224_ + partialTicks) / (float)this.duration, 0.001f);
        super.m_5744_(buffer, renderInfo, partialTicks);
    }

    public static class OrbData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<OrbData> DESERIALIZER = new ParticleOptions.Deserializer<OrbData>(){

            public OrbData fromCommand(ParticleType<OrbData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float r = (float)reader.readDouble();
                reader.expect(' ');
                float g = (float)reader.readDouble();
                reader.expect(' ');
                float b = (float)reader.readDouble();
                reader.expect(' ');
                float scale = (float)reader.readDouble();
                reader.expect(' ');
                int duration = reader.readInt();
                return new OrbData(r, g, b, scale, duration);
            }

            public OrbData fromNetwork(ParticleType<OrbData> particleTypeIn, FriendlyByteBuf buffer) {
                return new OrbData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt());
            }
        };
        private final float r;
        private final float g;
        private final float b;
        private final float scale;
        private final int duration;

        public OrbData(float r, float g, float b, float scale, int duration) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.scale = scale;
            this.duration = duration;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
            buffer.writeFloat(this.scale);
            buffer.writeInt(this.duration);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.scale), this.duration);
        }

        public ParticleType<OrbData> m_6012_() {
            return (ParticleType)ParticleInit.ORB.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getB() {
            return this.b;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getScale() {
            return this.scale;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getDuration() {
            return this.duration;
        }

        public static Codec<OrbData> CODEC(ParticleType<OrbData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("r").forGetter(OrbData::getR), (App)Codec.FLOAT.fieldOf("g").forGetter(OrbData::getG), (App)Codec.FLOAT.fieldOf("b").forGetter(OrbData::getB), (App)Codec.FLOAT.fieldOf("scale").forGetter(OrbData::getScale), (App)Codec.INT.fieldOf("duration").forGetter(OrbData::getDuration)).apply((Applicative)codecBuilder, OrbData::new));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class OrbFactory
    implements ParticleProvider<OrbData> {
        private final SpriteSet spriteSet;

        public OrbFactory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(OrbData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleOrb particle = new ParticleOrb(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getScale(), typeIn.getDuration());
            particle.m_108339_(this.spriteSet);
            particle.m_107253_(typeIn.getR(), typeIn.getG(), typeIn.getB());
            return particle;
        }
    }
}

